/*MDX to SMF   */
/*MAIN.c       */
/*2002.4.15 sam*/

#include <stdio.h>
#include <string.h>
#ifdef CBUILDER
	#include <alloc.h>
#else
	#include <malloc.h>
#endif


#include <math.h>
FILE *fin,*fout;
int TblS[4]={0,2,1,3};
char name[4][8]={"M1","M2","C1","C2"};
int MMLBase[16];
int FileBase;
int VoiceBase;
unsigned char *Ibuf;
unsigned char *Tbuf;
unsigned char Var[5];
long Ipos=0,EndPos,Tpos;
int NextOn,NextOff;

unsigned int Volume[16] = {
	0x2a,0x28,0x25,0x22,0x20,0x1d,0x1a,0x18,
	0x15,0x12,0x10,0x0d,0x0a,0x08,0x05,0x02,
};
struct OPDATA{
	//EG-Level
	unsigned char TL;
	unsigned char D1L;
	//EG-ADR
	unsigned char AR;
	unsigned char D1R;
	unsigned char D2R;
	unsigned char RR;
	//DeTune
	unsigned char KS;
	unsigned char DT1;
	unsigned char MUL;
	unsigned char DT2;
	unsigned char F_AME;
};

struct CHDATA{
	unsigned char F_PAN;//L:0x80Msk R:0x40Msk
	unsigned char CON;
	unsigned char FL;
	unsigned char AMS;
	unsigned char PMS;
	unsigned char F_NE;
	unsigned char OpMsk;
	struct OPDATA Op[4];
	char Name[16];
	unsigned char SPD;
	unsigned char PMD;
	unsigned char AMD;
	unsigned char WF;
	unsigned char NFQ;
};

struct CHDATA VoTbl[128];

const unsigned char HeadF[14]={
	'M','T','h','d',0x00,0x00,0x00,0x06,
	0x00,0x01,0x00,0x08,0x00,0x30
};

const unsigned char HeadFxB[28]={
	'C','c','n','K',0x00,0x00,0x00,0x00,
	'F','B','C','h',0x00,0x00,0x00,0x01,
	'V','O','P','M',0x00,0x00,0x00,0x01,
	0x00,0x00,0x00,0x80
};

enum
{
	kNumPrograms = 128,
	kNumOutputs = 2,

	kCon=0,
	kFL,
	kAMS,
	kPMS,
	kNFQ,
	kNE,
	kSPD,
	kAMD,
	kPMD,
	kWF,
	kOpMsk,

//OP M1
	kM1TL,

	kM1AR,
	kM1D1R,
 	kM1D1L,
	kM1D2R,
	kM1RR,
	kM1KS,
	kM1MUL,
	kM1DT1,
	kM1DT2,
	kM1F_AME,

//OP C1
	kC1TL,
	kC1AR,
	kC1D1R,
	kC1D1L,
	kC1D2R,
	kC1RR,
	kC1KS,
	kC1MUL,
	kC1DT1,
	kC1DT2,
	kC1F_AME,
//OP M2
	kM2TL,
	kM2AR,
	kM2D1R,
	kM2D1L,
	kM2D2R,
	kM2RR,
	kM2KS,
	kM2MUL,
	kM2DT1,
	kM2DT2,
	kM2F_AME,
	//OP C2
	kC2TL,
	kC2AR,
	kC2D1R,
	kC2D1L,
	kC2D2R,
	kC2RR,
	kC2KS,
	kC2MUL,
	kC2DT1,
	kC2DT2,
	kC2F_AME,
	kNumParams,
	kMskM1,
	kMskC1,
	kMskM2,
	kMskC2,
	kFileLoad,
	kFileSave,
	kWf0,
	kWf1,
	kWf2,
	kWf3,
	kCon0,
	kCon1,
	kCon2,
	kCon3,
	kCon4,
	kCon5,
	kCon6,
	kCon7
};

unsigned char getPrm(int CuProgNum,int index){
	struct CHDATA *pVo;
	pVo=&VoTbl[CuProgNum];
	switch (index)
	{
		case kCon:return(pVo->CON);
		case kFL:return(pVo->FL);
		case kAMS:return(pVo->AMS);
		case kPMS:return(pVo->PMS);
		case kNE:return((pVo->F_NE==128)?1:0);
		case kSPD:return(pVo->SPD);
		case kPMD:return(pVo->PMD);
		case kAMD:return(pVo->AMD);
		case kWF:return(pVo->WF);
		case kNFQ:return(pVo->NFQ);
		case kOpMsk:return(pVo->OpMsk);
		case kM1TL:return(pVo->Op[0].TL);
		case kM2TL:return(pVo->Op[1].TL);
		case kC1TL:return(pVo->Op[2].TL);
		case kC2TL:return(pVo->Op[3].TL);
		case kM1D1L:return(pVo->Op[0].D1L);
		case kM2D1L:return(pVo->Op[1].D1L);
		case kC1D1L:return(pVo->Op[2].D1L);
		case kC2D1L:return(pVo->Op[3].D1L);
		case kM1AR:return(pVo->Op[0].AR);
		case kM2AR:return(pVo->Op[1].AR);
		case kC1AR:return(pVo->Op[2].AR);
		case kC2AR:return(pVo->Op[3].AR);
		case kM1D1R:return(pVo->Op[0].D1R);
		case kM2D1R:return(pVo->Op[1].D1R);
		case kC1D1R:return(pVo->Op[2].D1R);
		case kC2D1R:return(pVo->Op[3].D1R);
		case kM1D2R:return(pVo->Op[0].D2R);
		case kM2D2R:return(pVo->Op[1].D2R);
		case kC1D2R:return(pVo->Op[2].D2R);
		case kC2D2R:return(pVo->Op[3].D2R);
		case kM1RR:return(pVo->Op[0].RR);
		case kM2RR:return(pVo->Op[1].RR);
		case kC1RR:return(pVo->Op[2].RR);
		case kC2RR:return(pVo->Op[3].RR);
		case kM1KS:return(pVo->Op[0].KS);
		case kM2KS:return(pVo->Op[1].KS);
		case kC1KS:return(pVo->Op[2].KS);
		case kC2KS:return(pVo->Op[3].KS);
		case kM1DT1:return(pVo->Op[0].DT1);
		case kM2DT1:return(pVo->Op[1].DT1);
		case kC1DT1:return(pVo->Op[2].DT1);
		case kC2DT1:return(pVo->Op[3].DT1);
		case kM1MUL:return(pVo->Op[0].MUL);
		case kM2MUL:return(pVo->Op[1].MUL);
		case kC1MUL:return(pVo->Op[2].MUL);
		case kC2MUL:return(pVo->Op[3].MUL);
		case kM1DT2:return(pVo->Op[0].DT2);
		case kM2DT2:return(pVo->Op[1].DT2);
		case kC1DT2:return(pVo->Op[2].DT2);
		case kC2DT2:return(pVo->Op[3].DT2);
		case kM1F_AME:return((pVo->Op[0].F_AME==128)?1:0);
 		case kM2F_AME:return((pVo->Op[1].F_AME==128)?1:0);
		case kC1F_AME:return((pVo->Op[2].F_AME==128)?1:0);
			case kC2F_AME:return((pVo->Op[3].F_AME==128)?1:0);
//OpMsk
		case kMskM1:return((pVo->OpMsk&0x08)?1:0);
		case kMskC1:return((pVo->OpMsk&0x10)?1:0);
		case kMskM2:return((pVo->OpMsk&0x20)?1:0);
		case kMskC2:return((pVo->OpMsk&0x40)?1:0);
//Con
		case kCon0:case kCon1:case kCon2:case kCon3:
		case kCon4:case kCon5:case kCon6:case kCon7:
			return((pVo->CON==(index-kCon0))?1:0);

//WF
		case kWf0:case kWf1:case kWf2: case kWf3:
			return((pVo->WF==(index-kWf0))?1:0);
			

	}
	return(0);
}

int header(void){
	int stat;
	int count;
	int index=0;
	unsigned char data;
	stat=0;
	count=0;
	do{
		data=fgetc(fin);
		count++;
		switch(stat){
			case 0:
				if(data==0x0d){stat=1;}
				break;
			case 1:
				if(data==0x0a){stat=2;}else{stat=0;}
				break;
			case 2:
				if(data==0x1a){stat=3;}else{stat=0;}
				break;
			case 3:

				if(data==0x00){stat=4;FileBase=count;}
				break;
			case 4:
				VoiceBase=data;
				VoiceBase&=0xff;
				VoiceBase<<=8;
				stat=5;
				break;
			case 5:
				VoiceBase&=0xff00;
				VoiceBase|=data;
				stat=6;
				break;
			case 6:
				if((count-1)==(MMLBase[0]+FileBase)){return(index);}
				MMLBase[index]=data;
				MMLBase[index]<<=8;

				stat=7;
				break;
			case 7:
				MMLBase[index]+=data;
				fprintf(stdout,"base %x %x\n",index,MMLBase[index]);
				index++;
				stat=6;
				break;

		}
	}while(count<65535);
	return(-1);
}

int InttoVar(unsigned int data){
	unsigned char tmp[5];
	int idx,i;
	idx=0;
	while(1){
		Var[idx]=data&0x7f;
		Var[idx]|=0x80;
		if(data>0x7f){
			data>>=7;
		}else{
			Var[0]&=0x7f;
			return(idx);
		}
		idx++;
	}
}

void setCuVar(void){
int i;
	i=InttoVar(NextOn);
	NextOn=0;
	for(;i!=-1;i--){
			Tbuf[Tpos++]=Var[i];
		}
}

void usage(void){
	fprintf(stderr,"\n\nMDX fmParametr Get Ver2.52+\n");
	fprintf(stderr,"			2002.6.21 (c) sam\n");
	fprintf(stderr,"usage:MDXPG2.exe [-h] InFileName [-o OutFileName(.fxb)] [-midi OutFileName(.mid)]\n");
	fprintf(stderr,"-h:help,this text.\n");
	fprintf(stderr,"InfileName:Set Input MdxFileName.\n");
	fprintf(stderr,"-o OutFileName:Set Output VST Bank FileName(*.fxb).\n");
	fprintf(stderr,"-midi OutFileName:Set Output SMF FileName(*.mid).\n");
}
void main(int argc,char *argv[]){
	char filename[64];
	char VoiceFile[64];
	char F_SMF=0;
	unsigned char dataH,dataL;
	unsigned short data2;
	unsigned char data;
	int stat;
	int indexMax;
	int F_Cont,F_Pol,F_CARRY;
	int OpNum;
	int pRep=0;
	int Repeat[8];
	int i,j,index,itmp;
	int CuBend,BaseBend;
	int defBend;
	int CuOn;
	int CuV;
	int f_tmpPan=0;
	int tmpVol;

	unsigned char BfNote=0xff;
	struct CHDATA *pVo;
	struct OPDATA *pOp;
	for(i=0;i<128;i++){
		pVo=&VoTbl[i];
		pVo->CON=0x00;
		pVo->FL=0x00;
		pVo->AMS=0x00;
			pVo->PMS=0x00;
		pVo->F_NE=0x00;
		pVo->OpMsk=0x40;
		sprintf(pVo->Name,"init-%d\0",i);
		pVo->SPD=0x7f;
		pVo->PMD=0x40;
		pVo->AMD=0x40;
		pVo->WF=0x00;
		pVo->NFQ=0x00;
		for(j=0;j<4;j++){
		pOp=&(pVo->Op[j]);
		/*EG-Level*/
			pOp->TL=0x00;
			pOp->D1L=0x00;
		/*EG-ADR*/
			pOp->AR=0x1f;
			pOp->D1R=0;
			pOp->D2R=0;
			pOp->RR=0x04;
		/*DeTune*/
			pOp->KS=0;
			pOp->DT1=0;
			pOp->MUL=1;
			pOp->DT2=0;
			pOp->F_AME=0;
		}
	}
	for(i=0;i<8;i++){
		Repeat[i]=0;
	}
	if((Ibuf=malloc(sizeof(char)*1024*64))==NULL){
		fprintf(stderr,"error,cat't alloc\n");
		return;
	}
	if((Tbuf=malloc(sizeof(char)*1024*64))==NULL){
		fprintf(stderr,"error,cat't alloc\n");
		return;
	}
		fin=stdin;
		fout=stdout;
		i=1;
		strcpy(filename,"stdin");
		if(argc==1){usage();return;}
		while(i<argc){
		if(strcmp(argv[i],"-h")==0){usage();return;}
		if(strcmp(argv[i],"-midi")==0){
			i++;
			if((fout=fopen(argv[i],"wb"))==NULL){
				fprintf(stderr,"MDXPG:OutFile can't write.\n");
				return;
			}
			F_SMF=1;
		}else{
			if(strcmp(argv[i],"-o")==0){
				i++;
				strcpy(VoiceFile,argv[i]);
			}else{

				if((fin=fopen(argv[i],"rb"))==NULL){
					fprintf(stderr,"%s\n",argv[i]);
					fprintf(stderr,"MDXPG:InFile not fond!!\n");
					return;
				}else{
					strcpy(filename,argv[i]);
				}
			}
		}
		i++;
		}
	if((indexMax=header())==-1){
		fprintf(stderr,"MDXPG:no header!!\n");
		return;
	}
	if(indexMax>8){indexMax=8;}
	Ipos=0;
	fprintf(stderr,"header OK\n");
	if(F_SMF==1){
		for(i=0;i<14;i++){
			fputc(HeadF[i],fout);
		}
	}
	fprintf(stderr,"MIDI header write\n");
	fseek(fin,FileBase,SEEK_SET);
	/*Base posbufɓAMMLBaseŃANZXł悤ɂB*/
	while((itmp=fgetc(fin))!=EOF){
		Ibuf[Ipos++]=itmp;
	}
	fprintf(stderr,"End of pos %x \n",Ipos);
	EndPos=Ipos-1;
	for(index=0;index<indexMax;index++){
		fprintf(stderr,"start track %d\n",index);
		Ipos=MMLBase[index];
		NextOn=index*8+1;
		f_tmpPan=0;
		NextOff=0;
		Tbuf[0]='M';
		Tbuf[1]='T';
		Tbuf[2]='r';
		Tbuf[3]='k';
		Tpos=8;
		F_Cont=0;
		F_Pol=0;
		CuBend=0;
		F_CARRY=0;
		BfNote=0xff;
		setCuVar();
		Tbuf[Tpos++]=0xC0+index;	/*ProgCng*/
		Tbuf[Tpos++]=0x01;			/*InitProg 1*/
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xB0+index;
		Tbuf[Tpos++]=0x65;
		Tbuf[Tpos++]=0x00;
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xB0+index;
		Tbuf[Tpos++]=0x64;
		Tbuf[Tpos++]=0x00;
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xB0+index;
		Tbuf[Tpos++]=0x06;
		Tbuf[Tpos++]=0x20;
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xB0+index;
		Tbuf[Tpos++]=0x0D;
		Tbuf[Tpos++]=0x00;
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xB0+index;
		Tbuf[Tpos++]=0x0C;
		Tbuf[Tpos++]=0x00;
		NextOn=1;
		setCuVar();
		Tbuf[Tpos++]=0xE0+index;
		Tbuf[Tpos++]=0x00;
		Tbuf[Tpos++]=0x40;
		NextOn=(indexMax-index)*8+2;


		do{
			data=Ibuf[Ipos++];
			if(data<=0x7f){
				NextOn+=data+1;

			} else{

			 if(data>=0x80 && data<=0xdf){
				if(F_Cont==0 ||	F_Cont==1){
					if(BfNote!=0xff){
						setCuVar();
						Tbuf[Tpos++]=0x80+index;	 /*NoteOn*/
						Tbuf[Tpos++]=(BfNote-0x80+3)&0x7f; /*Note*/
						Tbuf[Tpos++]=100;		/*vel*/
					}
					setCuVar();
					Tbuf[Tpos++]=0x90+index;	 /*NoteOn*/
					Tbuf[Tpos++]=(data-0x80+3)&0x7f; /*Note*/
					Tbuf[Tpos++]=100;		/*vel*/
					NextOn=0;
					CuBend=0;
					BfNote=data;
				}
				if((F_Cont==3 || F_Cont==2) && BfNote!=data){
					setCuVar();
					Tbuf[Tpos++]=0x90+index;	 /*NoteOn*/
					Tbuf[Tpos++]=(data-0x80+3)&0x7f; /*Note*/
					Tbuf[Tpos++]=100;		/*vel*/
					setCuVar();
					Tbuf[Tpos++]=0x80+index;	 /*NoteOn*/
					Tbuf[Tpos++]=(BfNote-0x80+3)&0x7f; /*Note*/
					Tbuf[Tpos++]=100;		/*vel*/
					NextOn=0;
					CuBend=0;
					if(F_Pol==1){
						/*xh߂*/
						setCuVar();
						Tbuf[Tpos++]=0xE0+index;
						Tbuf[Tpos++]=0x00;
						Tbuf[Tpos++]=0x40;
						F_Pol=0;
					}
					BfNote=data;
				}

				CuOn=Ibuf[Ipos++]+1;
				if(F_Pol==1){
					while(CuOn!=0){
						setCuVar();/*var deltaTime*/
						CuBend+=defBend;
						data2=(CuBend/128)+BaseBend+0x2000;
						data2&=0x3fff;
						Tbuf[Tpos++]=0xE0+index;
						Tbuf[Tpos++]=data2&0x7f;
						Tbuf[Tpos++]=(data2>>7)&0x7f;
						CuOn--;
						NextOn=1;
					}
				}else{NextOn+=CuOn;}
				if(F_Cont==0 || F_Cont==2){
					if(F_CARRY==1 && NextOn!=0){NextOn--;}
					setCuVar();
					Tbuf[Tpos++]=0x80+index;	 /*NoteOff*/
					Tbuf[Tpos++]=(BfNote-0x80+3)&0x7f; /*Note*/
					Tbuf[Tpos++]=0x00;		/*vel*/
					NextOn=0;
					F_CARRY=0;
					if(F_Pol==1){
						/*xh߂*/
						setCuVar();
						Tbuf[Tpos++]=0xE0+index;
						Tbuf[Tpos++]=0x00;
						Tbuf[Tpos++]=0x40;
					F_Pol=0;
					}
					BfNote=0xff;
				}
				switch(F_Cont){
					case 1: case 3:
						F_Cont=2;
					break;
					default: F_Cont=0;
					break;

				}
			}else{
			switch(data){
				case 0xff:
					/*tempo*/
					setCuVar();
					Tbuf[Tpos++]=0xff;
					Tbuf[Tpos++]=0x51;
					Tbuf[Tpos++]=0x03;
					itmp=6*2048.0*(float)(256.0-Ibuf[Ipos++]);
					Tbuf[Tpos++]=(itmp&0x00ff0000)>>16;
					Tbuf[Tpos++]=(itmp&0x0000ff00)>>8;
					Tbuf[Tpos++]=itmp&0x000000ff;
					break;
				case 0xfe:
					/*OPM reg*/
					Ipos+=2;
					break;

				case 0xfd:
					/*@F*/
					setCuVar();
					CuV=Ibuf[Ipos]&0x7f;
					fprintf(stderr,"Voice @%x\n",CuV);
					Tbuf[Tpos++]=0xC0+index;	/*ProgCng*/
					Tbuf[Tpos++]=(Ibuf[Ipos++]&0x7f);		/*No*/
					NextOn=1;
					F_CARRY=1;
					break;
				case 0xfc:
					/*PAN*/
					setCuVar();
					Tbuf[Tpos++]=0xB0+index;
					Tbuf[Tpos++]=0x0A;
					switch(Ibuf[Ipos++]){
						case 0x01:
							Tbuf[Tpos++]=0x00;
							f_tmpPan=1;
							break;
						case 0x02:
							Tbuf[Tpos++]=0x7f;
							f_tmpPan=1;
							break;
						case 0x03:
							Tbuf[Tpos++]=0x40;
							f_tmpPan=0;
							break;
						default:
							Tbuf[Tpos++]=0x40;
							f_tmpPan=0;
							break;
					}
/*
					setCuVar();
					Tbuf[Tpos++]=0xB0+index;
					Tbuf[Tpos++]=0x07;
					Tbuf[Tpos++]=tmpVol>>f_tmpPan;
*/
					break;
				case 0xfb:
					/**/
					setCuVar();
					Tbuf[Tpos++]=0xB0+index;
					Tbuf[Tpos++]=0x07;

					data2=Ibuf[Ipos++];

/*					if(data2<=15){
						tmpVol=(((data2<<3)+(data>>1))&0x7f);
					}
					if(data2>=0x80){
						tmpVol=((~data2)&0x7f);
					}
					tmpVol=(double)(127.0*sqrt(pow(10.0,(-0.75/20.0)*(127.0-(double)tmpVol))));
*/
					if(data2<=15){
						tmpVol=Volume[data2];
					}else{
					if(data2>=0x80){
						tmpVol=data2&0x7f;
					}}
					if(tmpVol>=0 && tmpVol<=127){
						if(tmpVol==0){tmpVol=127;}else{
							tmpVol=(double)(127.0*sqrt(pow(10.0,(-0.75/20.0)*tmpVol)));
						}
						if(tmpVol>127){tmpVol=127;}
						Tbuf[Tpos++]=tmpVol;
					}else{
						Tbuf[Tpos++]=0;
					}
					break;
				case 0xfa:
					/*fadeout*/
					break;
				case 0xf9:
					/*fadein*/
					break;
				case 0xf8:
					/**/
					Ipos++;
					break;
				case 0xf7:
					/*Key off */
					switch(F_Cont){
						case 0:F_Cont=1;
							break;
						case 2:F_Cont=3;
							break;
						default:
							F_Cont=0;
							break;

					}

					break;
				case 0xf6:
					Repeat[++pRep]=Ibuf[Ipos++];
					Ipos++;
					break;
				case 0xf5:
					data2=0;
					 data2=Ibuf[Ipos++];

					 data2<<=8;
					 data2&=0xff00;
					 data2+=Ibuf[Ipos++];
					 Repeat[pRep]--;
					 if(Repeat[pRep]!=0){
						Ipos+=data2;
						Ipos&=0xffff;
					 }else{pRep--;}
					break;
				case 0xf4:

					/*s[g֘A*/
					 data2=Ibuf[Ipos++];

					 data2<<=8;
					 data2&=0xff00;
					 data2+=Ibuf[Ipos++];
					 if(Repeat[pRep]==1){
						Ipos+=data2+2;
						Ipos&=0xffff;
						pRep--;
					 }
					break;
				case 0xf3:
					/*sb`xh*/
					data2=Ibuf[Ipos++];
					dataL=Ibuf[Ipos++];
					data2<<=8;
					data2&=0xff00;
					data2+=dataL;
						
					data2<<=1;/*xhW32̂Ƃ*/
					BaseBend=data2;
					data2+=0x2000;
					data2&=0x3fff;
					setCuVar();
					Tbuf[Tpos++]=0xE0+index;
					Tbuf[Tpos++]=data2&0x7f;
					Tbuf[Tpos++]=(data2>>7)&0x7f;

					break;
				case 0xf2:
					/*|^g*/
					itmp=Ibuf[Ipos++];
					itmp<<=8;
					itmp&=0xff00;
					itmp+=Ibuf[Ipos++];
					if(itmp>0x8000){itmp|=0xffff0000;}
					defBend=itmp;
					CuBend=0;
					F_Pol=1;
					break;
				case 0xee: case 0xe8:
					break;
				case 0xef: case 0xe9: case 0xf0:
					Ipos++;
					break;
				case 0xed:
					if(index==7){
						VoTbl[CuV].F_NE=Ibuf[Ipos]&0x80;
						VoTbl[CuV].NFQ=Ibuf[Ipos++]&0x7f;
					}else{Ipos++;}
					break;
				case 0xec: case 0xeb:
					data2=Ibuf[Ipos++];
					if(data2!=0x80 && data2!=0x81){
						Ipos+=4;
					}
					break;
				case 0xea:
					data2=Ibuf[Ipos++];
					if(data2!=0x80 && data2!=0x81){
						/*WaveForm data2*/
						VoTbl[CuV].WF=(data2&0x03);
						setCuVar();
						Tbuf[Tpos++]=0xB0+index;
						Tbuf[Tpos++]=0x4C;
						Tbuf[Tpos++]=Ibuf[Ipos++]>>1;
						setCuVar();
						Tbuf[Tpos++]=0xB0+index;
						Tbuf[Tpos++]=0x0D;
						Tbuf[Tpos++]=Ibuf[Ipos++]&0x7f;
						setCuVar();
						Tbuf[Tpos++]=0xB0+index;
						Tbuf[Tpos++]=0x0C;
						Tbuf[Tpos++]=Ibuf[Ipos++]&0x7f;
						dataL=Ibuf[Ipos++];
						if(dataL&0x03){
							VoTbl[CuV].AMS=(dataL&0x03);
						}
						if(dataL&0x70){
							VoTbl[CuV].PMS=(dataL>>4)&0x7;
						}
					}
					break;
				case 0xe7:
					if(Ibuf[Ipos++]==0x01){Ipos++;}
					break;

			}
			 }
			}
		}while(data!=0xf1);
		Tbuf[Tpos++]=0x00;
		Tbuf[Tpos++]=0xff;
		Tbuf[Tpos++]=0x2f;
		Tbuf[Tpos++]=0x00;
		Tbuf[4]=((Tpos-8)&0xff000000)>>24;
		Tbuf[5]=((Tpos-8)&0x00ff0000)>>16;
		Tbuf[6]=((Tpos-8)&0x0000ff00)>>8;
		Tbuf[7]=(Tpos-8)&0x000000ff;
		if(F_SMF==1){
			for(i=0;i<Tpos;i++){
				fputc(Tbuf[i],fout);
			}
		}
	}

	if(fout!=stdout){
		fclose(fout);
	}
	free(Tbuf);

	if((fout=fopen(VoiceFile,"wb"))==NULL){
		fprintf(stderr,"MDXPG:OutFile can't write.\n");
		fout=stdout;
	}
/*Parm Out*/
		Ipos=VoiceBase;
		index=0;
		stat=0;
		pVo=&VoTbl[0];
		while(EndPos>=Ipos){
		data=Ibuf[Ipos++];
		switch(stat){
			case 0:
				/*F*/
				CuV=data&0x7f;
				pVo=&VoTbl[CuV];
				sprintf(pVo->Name,"%s-@%d\0",filename,data);
				stat++;
				break;
			case 1:
				/*FL & CON*/
				pVo->FL=(data>>3)&0x07;
				pVo->CON=data&0x07;
				pVo->F_PAN=0xc0;
				stat++;
				break;
			case 2:
				/*slotMsk*/
				pVo->OpMsk=(data<<3)&0x78;
				stat++;
				index=0;
				break;
			case 3:
				/*DT&MUL*/
				pVo->Op[index].DT1=(data>>4)&0x07;
				pVo->Op[index].MUL=data&0x0f;
				if(index==3){
					stat++;
					index=0;
				}else{
					index++;
				}
				break;
			case 4:
				/*TL*/
				pVo->Op[index].TL=data;
 				if(index==3){
					stat++;
					index=0;
				}else{
					index++;
				}
				break;
			case 5:
				/*KS&AR*/
				pVo->Op[index].KS=(data>>6)&0x03;
				pVo->Op[index].AR=data&0x1f;
				if(index==3){
					stat++;
					index=0;
				}else{
					index++;
				}
				break;
			case 6:
				/*AME&D1R*/
				pVo->Op[index].F_AME=data&0x80;
				pVo->Op[index].D1R=data&0x1f;
 				if(index==3){
					stat++;
					index=0;
				}else{
					index++;
				}
				break;
			case 7: /*DT2&D2R*/
				pVo->Op[index].DT2=(data>>6)&0x3;
				pVo->Op[index].D2R=data&0x1f;
				if(index==3){
					stat++;
					index=0;
				}else{
					index++;
				}
				break;
			case 8: /*D1L&RR*/
				pVo->Op[index].D1L=(data>>4)&0x0f;
				pVo->Op[index].RR=data&0x0f;
				if(index==3){
					index=0;
					stat=0;
				}else{
					index++;
				}
				break;
		}

	}
	for(i=0;i<28;i++){
		fputc(HeadFxB[i],fout);
	}
	fseek(fout,128,SEEK_CUR);
	fputc(0,fout);
	fputc(0,fout);
	fputc(0x23,fout);
	fputc(0x80,fout);
	for(i=0;i<128;i++){
		for(index=0;index<kNumParams;index++){
			fputc(getPrm(i,index),fout);
		}
		for(index=0;index<15;index++){
			fputc(VoTbl[i].Name[index],fout);
		}
		fputc(0,fout);
	}
	if(fin!=stdin){
		fclose(fin);
	}
	if(fout!=stdout){
		fclose(fout);
	}
	free(Ibuf);
}

//---------------------------------------------------------------------------

